-- MIGRAÇÃO para protocolo + categorias
ALTER TABLE denuncias CHANGE codigo protocolo VARCHAR(32) NULL;

CREATE TABLE IF NOT EXISTS categorias (
  id INT AUTO_INCREMENT PRIMARY KEY,
  nome VARCHAR(120) NOT NULL UNIQUE,
  ativo TINYINT(1) NOT NULL DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT IGNORE INTO categorias (id, nome, ativo) VALUES
(1,'Assédio Moral',1),
(2,'Assédio Sexual',1),
(3,'Discriminação',1),
(4,'Fraude / Corrupção',1),
(5,'Roubo / Furto',1),
(6,'Conflito de Interesses',1),
(7,'Outros',1);

ALTER TABLE denuncias ADD COLUMN categoria_id INT NULL AFTER descricao;
ALTER TABLE denuncias ADD CONSTRAINT fk_denuncia_categoria FOREIGN KEY (categoria_id) REFERENCES categorias(id) ON DELETE SET NULL;

-- Protocolo para registros antigos (melhor gerar via script PHP para AAAAMMDDHHIISS-ID)
UPDATE denuncias SET protocolo = DATE_FORMAT(criado_em, '%Y%m%d%H%i%S') WHERE protocolo IS NULL;
