<?php $d=$GLOBALS['d']; $coment=$GLOBALS['coment']; $anexos=$GLOBALS['anexos']; ?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h1 class="h4 mb-0">Denúncia #<?=$d['id']?> — <?=safe_str($d['protocolo'])?></h1>
  <span class="badge text-bg-info">Status: <?=safe_str($d['status'])?></span>
</div>
<div class="row g-3">
  <div class="col-lg-8">
    <div class="card">
      <div class="card-body">
        <h5 class="card-title"><?=safe_str($d['titulo'])?></h5>
        <p class="text-muted small mb-1">Categoria: <?=safe_str($d['categoria']?:'—')?> • Local: <?=safe_str($d['localizacao']?:'—')?></p>
        <p><?=nl2br(safe_str($d['descricao']))?></p>
        <hr>
        <h6>Anexos</h6>
        <?php if ($anexos): ?><ul class="mb-0"><?php foreach($anexos as $a): ?><li><a href="<?=safe_str($a['caminho'])?>" target="_blank"><?=safe_str($a['nome_original'])?></a></li><?php endforeach; ?></ul><?php else: ?><p class="text-muted">Nenhum anexo.</p><?php endif; ?>
      </div>
    </div>
    <div class="card mt-3" id="comentarios">
      <div class="card-body">
        <h6 class="card-title">Comentários</h6>
        <?php if ($coment): foreach($coment as $c): ?>
          <div class="mb-3">
            <div class="small text-muted">Por: <?=safe_str($c['nome']?:'—')?> • <?=$c['criado_em']?> <?= $c['visivel_ao_denunciante']?'<span class="badge text-bg-success">Visível ao denunciante</span>':'' ?></div>
            <div><?=nl2br(safe_str($c['texto']))?></div>
          </div>
        <?php endforeach; else: ?>
          <p class="text-muted">Sem comentários.</p>
        <?php endif; ?>
        <form class="mt-3" method="post" action="/denuncia/<?=$d['id']?>/comentario">
          <input type="hidden" name="csrf" value="<?=csrf_token()?>">
          <div class="mb-2"><textarea class="form-control" name="texto" rows="3" required></textarea></div>
          <div class="form-check mb-2">
            <input class="form-check-input" type="checkbox" name="visivel" id="vis">
            <label for="vis" class="form-check-label">Visível ao denunciante</label>
          </div>
          <button class="btn btn-primary btn-sm">Adicionar comentário</button>
        </form>
      </div>
    </div>
  </div>
  <div class="col-lg-4">
    <div class="card"><div class="card-body">
      <h6 class="card-title">Triagem & Atribuição</h6>
      <?php if (can(['administrador','gerente'])): ?>
      <form method="post" action="/denuncia/<?=$d['id']?>/status">
        <input type="hidden" name="csrf" value="<?=csrf_token()?>">
        <div class="mb-2">
          <label class="form-label">Status</label>
          <select class="form-select" name="status">
            <?php foreach(['nova','em_triagem','em_investigacao','concluida','descartada'] as $s): ?>
              <option value="<?=$s?>" <?=$d['status']===$s?'selected':''?>><?=$s?></option>
            <?php endforeach; ?>
          </select>
        </div>
        <div class="mb-2">
          <label class="form-label">Responsável</label>
          <select class="form-select" name="atribuido_a">
            <option value="">—</option>
            <?php foreach(Usuario::allManagers($pdo) as $m): ?>
              <option value="<?=$m['id']?>" <?=$d['atribuido_a']==$m['id']?'selected':''?>><?=safe_str($m['nome'])?></option>
            <?php endforeach; ?>
          </select>
        </div>
        <div class="mb-2">
          <label class="form-label">Prazo</label>
          <input type="datetime-local" class="form-control" name="prazo" value="<?= $d['prazo']? date('Y-m-d\TH:i', strtotime($d['prazo'])):'' ?>">
        </div>
        <button class="btn btn-primary btn-sm">Salvar</button>
      </form>
      <?php else: ?>
        <p class="text-muted">Somente gerentes/administradores podem atualizar o status.</p>
      <?php endif; ?>
    </div></div>
  </div>
</div>
