<?php
class Denuncia {
  public static function create(PDO $pdo, $data){
    $st=$pdo->prepare("INSERT INTO denuncias(titulo,descricao,categoria_id,localizacao,anonima,denunciante_usuario_id,denunciante_hash,prioridade)
                       VALUES (:titulo,:descricao,:categoria_id,:localizacao,:anonima,:denunciante_usuario_id,:denunciante_hash,:prioridade)");
    $st->execute($data);
    $id = $pdo->lastInsertId();
    $protocolo = date('YmdHis') . '-' . $id;
    $up=$pdo->prepare('UPDATE denuncias SET protocolo=:p WHERE id=:id');
    $up->execute([':p'=>$protocolo, ':id'=>$id]);
    return $id;
  }
  public static function getProtocolo(PDO $pdo,$id){
    $st=$pdo->prepare('SELECT protocolo FROM denuncias WHERE id=:id'); $st->execute([':id'=>$id]); return $st->fetchColumn();
  }
  public static function findById(PDO $pdo, $id){
    $st=$pdo->prepare('SELECT d.*, u.nome as responsavel, c.nome as categoria
                       FROM denuncias d
                       LEFT JOIN usuarios u ON u.id=d.atribuido_a
                       LEFT JOIN categorias c ON c.id=d.categoria_id
                       WHERE d.id=:id');
    $st->execute([':id'=>$id]); return $st->fetch();
  }
  public static function byRoleList(PDO $pdo, $user){
    if ($user['perfil']==='colaborador'){
      $st=$pdo->prepare("SELECT id,protocolo,titulo,status,prioridade,criado_em FROM denuncias WHERE denunciante_usuario_id=:id OR anonima=1 ORDER BY criado_em DESC");
      $st->execute([':id'=>$user['id']]); return $st->fetchAll();
    }
    return $pdo->query('SELECT id,protocolo,titulo,status,prioridade,criado_em FROM denuncias ORDER BY criado_em DESC')->fetchAll();
  }
  public static function updateStatus(PDO $pdo,$id,$status,$atribuido=null,$prazo=null){
    $st=$pdo->prepare('UPDATE denuncias SET status=:s, atribuido_a=:a, prazo=:p WHERE id=:id');
    $st->execute([':s'=>$status,':a'=>$atribuido,':p'=>$prazo,':id'=>$id]);
  }
  public static function findByProtocolo(PDO $pdo,$prot){
    $st=$pdo->prepare('SELECT d.id,d.protocolo,d.titulo,d.status,d.prioridade,c.nome as categoria,d.localizacao,d.criado_em,d.atualizado_em
                       FROM denuncias d
                       LEFT JOIN categorias c ON c.id=d.categoria_id
                       WHERE d.protocolo=:p');
    $st->execute([':p'=>$prot]);
    $d=$st->fetch();
    if(!$d) return null;
    $c=$pdo->prepare('SELECT texto, criado_em FROM comentarios WHERE denuncia_id=:id AND visivel_ao_denunciante=1 ORDER BY criado_em');
    $c->execute([':id'=>$d['id']]);
    $d['comentarios']=$c->fetchAll();
    return $d;
  }
}
