<?php
require_once __DIR__.'/../models/Denuncia.php';
require_once __DIR__.'/../models/Comentario.php';
require_once __DIR__.'/../models/Anexo.php';
require_once __DIR__.'/../models/Audit.php';
require_once __DIR__.'/../models/Usuario.php';
require_once __DIR__.'/../models/Categoria.php';
require_once __DIR__.'/../lib/email.php';

class DenunciasController {
  public static function home(PDO $pdo){ auth_check(); $_view='home_inner.php'; require __DIR__.'/../views/layout.php'; }
  public static function listar(PDO $pdo){ auth_check(); $user=auth_user(); $rows=Denuncia::byRoleList($pdo,$user); $GLOBALS['_rows']=$rows; $_view='denuncias_listar_inner.php'; require __DIR__.'/../views/layout.php'; }
  public static function novaForm(PDO $pdo){ auth_check(); $GLOBALS['_cats']=Categoria::active($pdo); $_view='denuncias_nova_inner.php'; require __DIR__.'/../views/layout.php'; }

  public static function criar(PDO $pdo){
    csrf_check();
    $user = auth_user();
    $anon = isset($_POST['anonima']) ? 1 : 0;
    $data = [
      ':titulo' => trim($_POST['titulo']??''),
      ':descricao' => trim($_POST['descricao']??''),
      ':categoria_id' => !empty($_POST['categoria_id']) ? (int)$_POST['categoria_id'] : null,
      ':localizacao' => trim($_POST['localizacao']??''),
      ':anonima' => $anon,
      ':denunciante_usuario_id' => $anon? null : ($user['id'] ?? null),
      ':denunciante_hash' => hash('sha256', ($_SERVER['HTTP_USER_AGENT'] ?? 'ua').'|'.( $_COOKIE['rpt'] ?? bin2hex(random_bytes(16)) )),
      ':prioridade' => $_POST['prioridade'] ?? 'media'
    ];
    $id = Denuncia::create($pdo,$data);
    if (!empty($_FILES['anexos']['name'][0])) { self::handleUploads($pdo,$id); }
    $prot = Denuncia::getProtocolo($pdo,$id);
    Audit::log($pdo,$user['id']??null,'CRIAR','denuncias',$id,['protocolo'=>$prot,'anonima'=>$anon]);
    $dest = envv('SMTP_FROM'); if ($dest) enviar_email($dest, 'Nova denúncia registrada', '<p>Protocolo: <b>'.$prot.'</b></p>');
    header('Location: /denuncia/'.$id);
  }

  public static function publicaForm(PDO $pdo){ $GLOBALS['_cats']=Categoria::active($pdo); $_view='publico_denuncia_inner.php'; require __DIR__.'/../views/layout.php'; }

  public static function publicaCriar(PDO $pdo){
    csrf_check();
    $data = [
      ':titulo' => trim($_POST['titulo']??''),
      ':descricao' => trim($_POST['descricao']??''),
      ':categoria_id' => !empty($_POST['categoria_id']) ? (int)$_POST['categoria_id'] : null,
      ':localizacao' => trim($_POST['localizacao']??''),
      ':anonima' => 1,
      ':denunciante_usuario_id' => null,
      ':denunciante_hash' => hash('sha256', ($_SERVER['HTTP_USER_AGENT'] ?? 'ua').'|'.( $_COOKIE['rpt'] ?? bin2hex(random_bytes(16)) )),
      ':prioridade' => $_POST['prioridade'] ?? 'media'
    ];
    $id = Denuncia::create($pdo,$data);
    if (!empty($_FILES['anexos']['name'][0])) { self::handleUploads($pdo,$id); }
    $prot = Denuncia::getProtocolo($pdo,$id);
    Audit::log($pdo,null,'CRIAR_PUBLICO','denuncias',$id,['protocolo'=>$prot,'anonima'=>1]);
    $dest = envv('SMTP_FROM'); if ($dest) enviar_email($dest, 'Nova denúncia anônima', '<p>Protocolo: <b>'.$prot.'</b></p>');
    $GLOBALS['_protocolo']=$prot;
    $_view='publico_sucesso_inner.php'; require __DIR__.'/../views/layout.php';
  }

  public static function consultaForm(){ $_view='publico_consulta_inner.php'; require __DIR__.'/../views/layout.php'; }
  public static function consultaBuscar(PDO $pdo){
    $prot = strtoupper(trim($_POST['protocolo'] ?? ''));
    $d = Denuncia::findByProtocolo($pdo,$prot);
    $GLOBALS['_consulta']=$d;
    $_view='publico_consulta_inner.php'; require __DIR__.'/../views/layout.php';
  }

  private static function handleUploads(PDO $pdo,$denuncia_id){
    $maxMb = (int)(envv('UPLOAD_MAX_MB',10));
    $allowed = array_map('strtolower', explode(',', envv('ALLOWED_EXT','pdf,jpg,jpeg,png,txt,docx,xlsx')));
    $base = __DIR__.'/../../public/uploads';
    if (!is_dir($base)) mkdir($base,0750,true);
    for ($i=0; $i<count($_FILES['anexos']['name']); $i++){
      if (!$_FILES['anexos']['size'][$i]) continue;
      $orig = $_FILES['anexos']['name'][$i];
      $tmp = $_FILES['anexos']['tmp_name'][$i];
      $size = (int)$_FILES['anexos']['size'][$i];
      if ($size > $maxMb*1024*1024) continue;
      $ext = strtolower(pathinfo($orig, PATHINFO_EXTENSION));
      if (!in_array($ext,$allowed,true)) continue;
      $fname = bin2hex(random_bytes(16)).'.'.$ext;
      $dest = $base.'/'.$fname;
      if (move_uploaded_file($tmp,$dest)){
        Anexo::add($pdo,$denuncia_id,$orig,'/uploads/'.$fname,mime_content_type($dest)?:null,$size);
      }
    }
  }

  public static function ver(PDO $pdo,$id){
    auth_check();
    $user=auth_user();
    $d=Denuncia::findById($pdo,$id);
    if(!$d){ http_response_code(404); die('Não encontrada'); }
    $coment=Comentario::listByDenuncia($pdo,$id,$user);
    $anexos=Anexo::list($pdo,$id);
    $GLOBALS['d']=$d; $GLOBALS['coment']=$coment; $GLOBALS['anexos']=$anexos;
    $_view='denuncia_ver_inner.php'; require __DIR__.'/../views/layout.php';
  }

  public static function comentar(PDO $pdo,$id){
    csrf_check(); auth_check();
    $user=auth_user();
    $visivel = isset($_POST['visivel']);
    Comentario::add($pdo,$id,$user['id']??null, trim($_POST['texto']??''), $visivel);
    Audit::log($pdo,$user['id']??null,'COMENTAR','denuncias',$id,['visivel'=>$visivel]);
    header('Location: /denuncia/'.$id.'#comentarios');
  }

  public static function atualizarStatus(PDO $pdo,$id){
    csrf_check(); require_roles(['gerente','administrador']);
    $status = $_POST['status'] ?? 'em_triagem';
    $atr = !empty($_POST['atribuido_a']) ? (int)$_POST['atribuido_a'] : null;
    $prazo = !empty($_POST['prazo']) ? $_POST['prazo'] : null;
    Denuncia::updateStatus($pdo,$id,$status,$atr,$prazo);
    Audit::log($pdo,auth_user()['id']??null,'STATUS','denuncias',$id,['status'=>$status,'atribuido_a'=>$atr,'prazo'=>$prazo]);
    header('Location: /denuncia/'.$id);
  }
}
