<?php
require_once __DIR__.'/../models/Categoria.php';
class CategoriasController {
  public static function index(PDO $pdo){ require_roles('administrador'); $GLOBALS['_cats']=Categoria::all($pdo); $_view='categorias_listar_inner.php'; require __DIR__.'/../views/layout.php'; }
  public static function novo(){ require_roles('administrador'); $GLOBALS['_cat']=null; $_view='categorias_form_inner.php'; require __DIR__.'/../views/layout.php'; }
  public static function criar(PDO $pdo){ require_roles('administrador'); csrf_check(); $nome=trim($_POST['nome']??''); $ativo=isset($_POST['ativo']); if(!$nome){ $_SESSION['flash']='Informe o nome.'; header('Location: /categorias/novo'); return; } try{ Categoria::create($pdo,$nome,$ativo); $_SESSION['flash_success']='Categoria criada.'; header('Location: /categorias'); } catch (PDOException $e){ $_SESSION['flash']='Erro: '.$e->getMessage(); header('Location: /categorias/novo'); } }
  public static function editar(PDO $pdo,$id){ require_roles('administrador'); $c=Categoria::find($pdo,$id); if(!$c){ http_response_code(404); echo 'Categoria não encontrada'; return; } $GLOBALS['_cat']=$c; $_view='categorias_form_inner.php'; require __DIR__.'/../views/layout.php'; }
  public static function atualizar(PDO $pdo,$id){ require_roles('administrador'); csrf_check(); $nome=trim($_POST['nome']??''); $ativo=isset($_POST['ativo']); if(!$nome){ $_SESSION['flash']='Informe o nome.'; header('Location: /categorias/'.$id.'/editar'); return; } try{ Categoria::update($pdo,$id,$nome,$ativo); $_SESSION['flash_success']='Categoria atualizada.'; header('Location: /categorias'); } catch (PDOException $e){ $_SESSION['flash']='Erro: '.$e->getMessage(); header('Location: /categorias/'.$id.'/editar'); } }
  public static function excluir(PDO $pdo,$id){ require_roles('administrador'); csrf_check(); try{ Categoria::delete($pdo,$id); $_SESSION['flash_success']='Categoria excluída.'; } catch (PDOException $e){ $_SESSION['flash']='Erro: '.$e->getMessage(); } header('Location: /categorias'); }
}
