<?php
$env = parse_ini_file(__DIR__ . '/../../.env');
date_default_timezone_set($env['TZ'] ?? 'America/Bahia');
$dsn = sprintf('mysql:host=%s;dbname=%s;charset=utf8mb4', $env['DB_HOST'], $env['DB_NAME']);
$options = [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION, PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC];
try {
  $pdo = new PDO($dsn, $env['DB_USER'], $env['DB_PASS'], $options);
  $pdo->exec("SET time_zone = '-03:00'");
} catch (PDOException $e) { http_response_code(500); die('Erro de conexão: ' . $e->getMessage()); }
